'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' "LATH-E-BOY" LATHE CONTROL
' V 8.3.1
'PL Bennett
'9-10-17

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'DISCLAIMER: THIS SOFTWARE IS PROVIDED FREE WITHOUT WARRANTY. 
'THE USER MUST DETERMINE FITNESS FOR THEIR OWN PURPOSE.
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'ENTER THESE OPTIONS FROM THE COMMAND LINE BEFORE INITIAL EXECUTION OF THE PROGRAM
'OPTION CONSOLE AUTO
'OPTION LCDPANEL SSD1963_5, LANDSCAPE
'OPTION TOUCH 1, 40, 39
'OPTION SDCARD 52
'GUI CALIBRATE      'only required if setting up touchscreen initially

'ENTER YOUR PREFERRED VALUE FOR THESE VARIABLES
'max_spindle_hi= [your speed]   'enter maximum spindle rpm here to be saved in flash
'max_spindle_med= [your speed]   'enter maximum spindle rpm here to be saved in flash
'max_spindle_lo= [your speed]   'enter maximum spindle rpm here to be saved in flash
'min_spindle_hi= [your speed]   'enter minimum spindle rpm here to be saved in flash
'min_spindle_med= [your speed]   'enter minimum spindle rpm here to be saved in flash
'min_spindle_lo= [your speed]   'enter minimum spindle rpm here to be saved in flash
'feedback_interval=[your interval]  'enter time between speed error corrections
'feedback_quantity=[your preference]  'fraction of error to feed back for each correction

'SAVE YOUR PREFERRED VALUES IF YOU WANT THEM RESTORED AT STARTUP (Not usually necessary)
'VAR SAVE max_spindle_hi, max_spindle_med, max_spindle_lo,        'save in flash. Will be restored each time the program starts
'VAR SAVE min_spindle_hi, min_spindle_med, min_spindle_lo,        'save in flash. Will be restored each time the program starts
'VAR SAVE feedback_interval, feedback_quantity                    'save in flash. Will be restored each time the program starts

'Initialise
Option explicit
Option autorun on
CLS               'clear the screen of all shrapnel
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'configure the hardware
SetPin 76, inth, get_period   'interrupt/read state of Read_RPM input pin
SetPin 41, DOUT =0  'run command
SetPin 34, DOUT =0  'reverse
SetPin 33, DOUT =0  'isolate starter winding
SetPin 32, DOUT =0  'isolate main winding
SetPin 74, DOUT     'PWM speed control
SetPin 51, DIN, pullup     'micro SD card detect
setpin 44, din      'pulls low when ramp is up_to_speed, high while ramping. Gate with pin(cont_run)
setpin 35, dout     'debug. Interface pin 19
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'Define the variables
Dim matl_overlay$(7)LENGTH 15=("Aluminium","Mild Steel","Stainless","Carbon Steel","Brass","Bronze","Plastics","Wood")  'material spinbox overlay is in text array
Dim matl_speed(7)=(105,40,23,21,90,24,113,190)    'cutting speeds in m/min respectively
Dim tweak_flag =0    'set if tweak spinbox interrupts, clear if auto button pressed
Dim set_rpm          'set PWM to give appropriate control voltage
Dim work_dia        'selected workpiece diameter mm
Dim stopped=1       'asserted when motor stopped or initialised
Dim fwd_status=0      'remember that fwd was asserted
Dim rev_status=0      'remember that rev was asserted
Dim errornbr        'used to test for errors
Dim man_auto=0        'flag to remember if manual or auto speed selected. 1=manual
Dim measured_rpm      'actual rpm
Dim adj_target_period    'adjusted target period to give correct actual rpm
dim tweak_flag2=0     'lets main loop know a tweak occurred
dim tick1=0          'set by interrupt routine to time start winding
dim tick2=0          'set by interrupt to time machine deceleration when changing direction
dim tick3=0          'opens gate for rpm interrupt to correct speed error
dim tick4=0          'rpm display timer
dim pwm_rpm          'used to adjust speed error in main loop
dim pwm_ratio        'sets the corrected controller rpm
dim rpm_sync=0       'if =1 then converging actual rpm on target
dim max_spindle_period  'max spindle period value depends on belt position
dim min_spindle_period  'min spindle period value depends on belt position
dim max_spindle_rpm     'max spindle rpm value depends on belt position
dim min_spindle_rpm     'min spindle rpm value depends on belt position
dim max_spindle_hi_period=19.75    'CUSTOMISE 19.75 ms ~ 820 RPM 
dim max_spindle_med_period=20  'CUSTOMISE 20 ms ~ 600 RPM
dim max_spindle_lo_period=19.75   'CUSTOMISE 19.75 ms ~ 450 RPM
dim max_spindle_hi_rpm=820      'CUSTOMISE 73 ms ~ 820 RPM 
dim max_spindle_med_rpm=600     'CUSTOMISE 100 ms ~ 600 RPM
dim max_spindle_lo_rpm=450      'CUSTOMISE 133 ms ~ 450 RPM
dim min_spindle_hi_period=56   'CUSTOMISE 56 ms ~ 270 RPM
dim min_spindle_med_period=56  'CUSTOMISE 56 ms ~ 210 RPM
dim min_spindle_lo_period=56.5   'CUSTOMISE 56.5 ms ~ 160 RPM
dim min_spindle_hi_rpm=270      'CUSTOMISE 223 ms ~ 270 RPM
dim min_spindle_med_rpm=210     'CUSTOMISE 290 ms ~ 210 RPM
dim min_spindle_lo_rpm=160      'CUSTOMISE 385 ms ~ 160 RPM
dim pulse_id=0           'id of interrupts on pin 76 (rpm in)
dim period                'time between pulses for rpm in
dim target_period            'used to apply speed correction
dim avg_rpm=0             'for real rpm display
dim avg_count=0           'for calculating real rpm display
dim feedback_interval=200 'time between speed corrections
dim feedback_quantity=0.75  'proportion of error to feed back for each correction

Dim As string SPLASH1.BMP     'splash screen id

VAR restore           'bring customised variables back from flash

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'set up the constants
Const fwd=1 'forward drive button
Const rpm_off=2  'power off button
Const rev=3 'reverse drive button
Const go_P2=7 'button to switch to setup page
Const go_P1=23  'button to switch to operation page
Const matl=20 'material spinbox
Const disp_matl=11    'displaybox material type
Const dia=21  'diameter spinbox
Const choose_man=22 'button to choose manual speed selection
Const manual=24 'spinbox to manually select RPM
Const choose_auto=30 'button to choose auto speed selection
Const manual_caption=28 'caption alonside manual RPM spinbox
Const overlay=31  'displaybox located above material spinbox
Const P1_target=8   'target speed displaybox
Const tweak_rpm=38    'spinbox to tweak speed on the fly
Const real_rpm=19    'actual rpm display
Const cont_run=41    'run signal to controller
Const rel_rev=34    'changeover relay fwd/rev.
Const rel_start=33  'start winding activate/isolate relay.
Const rel_main=32     'main winding activate relay.
const range_hi=51   'high range button
const range_med=52    'medium range button
const range_lo=53   'low range button

If Pin(51)=0 Then
  Load image "SPLASH1.BMP",1,1   'show the splash screen only if micro SD detected
  Pause 1000
End If
CLS

'initialise interrupts

'enable touch interrupts
GUI interrupt Touched   'call Touched when any gui control activated
settick 200, start_off, 1   'call sub every 200 ms for start winding dwell 
settick 100, decelerate, 2     'call sub every 100 ms to time spindle slowdown after power off
settick feedback_interval, feedback, 3    'allow a speed correction adjustment every <feedback_value> ms 
settick 500, display_rpm, 4

PWM 1, 4000,0   'initialise PWM off

'###################################################################
'Build Page 1, the operate page
GUI setup 1   'controls allocated to Page 1 until next gui setup #n

'Create the frame then put the buttons in
font 5
GUI frame 5,"LATH-E-BOY",10,20,370,440,RGB(yellow)   'draw the frame
GUI radio 1,"FORWARD",50,60,80,RGB(green)   'draw the radio buttons
GUI radio 2,"OFF",50,190,80, RGB(blue)
GUI radio 3,"REVERSE",50,320,80,RGB(red)
CtrlVal(2)=1     'initialise lathe drive to OFF

'button to switch from OPERATE (PAGE 1)to SETUP (PAGE 2)
Font 4
GUI button 7,"Setup",400,380,140,80,RGB(black),RGB(yellow)

'display target speed, actual speed, diameter, material in displayboxes.
Font 4
GUI displaybox 8,570,120,220,50,RGB(blue),RGB(white) 'target speed
gui displaybox 19,570,175,220,50,rgb(blue),rgb(white)    'actual speed
GUI displaybox 10,570,230,220,50,RGB(blue),RGB(white)   'workpiece diameter
GUI displaybox 11,570,285,220,50,RGB(blue),RGB(white)   'material

'annotate target speed, actual speed, diameter, material displays
GUI caption 12,"Target RPM",400,145,Lm,RGB(white),RGB(black) 'target speed annotation
GUI caption 13,"Actual RPM",400,200,Lm,RGB(white),RGB(black) 'actual speed annotation
GUI caption 14,"Diameter",400,255,Lm,RGB(white),RGB(black) 'workpiece diameter annotation
GUI caption 15,"Material",400,310,Lm,RGB(white),RGB(black) 'workpiece material annotation

'facility to adjust speed on the fly
GUI spinbox tweak_rpm,420,50,350,50,RGB(blue),RGB(white),10,30,max_spindle_hi_rpm
GUI caption 37,"Tweak RPM on-the-fly",430,25,Lm,RGB(white),RGB(black)   'on the fly caption

'Select belt range 
Font 4
GUI frame 32," Belt drive ",565,355,220,105,RGB(yellow)   'draw the frame
GUI button 53,"",720,370,50,50,RGB(black),rgb(green)   'draw the switches
GUI button 52,"",650,370,50,50, RGB(black),rgb(blue)
GUI button 51,"",580,370,50,50,rgb(black),RGB(red)
gui caption 39,"Fast Med Slow",570,440,LM,rgb(white),rgb(black)
gui bcolour RGB(white),53,52   'set default speed range to HIGH
max_spindle_period=max_spindle_hi_period  'set default top speed period
max_spindle_rpm=max_spindle_hi_rpm  'set default top speed rpm
min_spindle_period=min_spindle_hi_period  'set default bottom speed period
min_spindle_rpm=min_spindle_hi_rpm  'set default bottom speed rpm

'##########################################################

'Now build PAGE 2, the Setup page
GUI setup 2   'assign all following controls to Page 2
font 4
GUI frame 29,"SETUP PARAMETERS",2,10,796,468,RGB(red),RGB(black)

'dimension material spinbox here.
GUI spinbox 20,20,80,350,50,RGB(blue),RGB(white),1,0,7   'allows for 8 materials in a list (last parameter)
GUI caption 25,"Material",400,105,LM,RGB(white),RGB(black)  'annotate the spinbox
GUI displaybox overlay,70,43,250,30,RGB(blue),RGB(white)'initialise the material display

'dimension diameter spinbox
GUI spinbox 21,20,180,350,50,RGB(blue),RGB(white),1,2,250
GUI caption 27,"Diameter mm",400,205,LM,RGB(white),RGB(black)  'annotate the spinbox

'dimension auto and manual speed buttons
GUI button 22,"Manual RPM",20,380,185,80,RGB(blue),RGB(white)
GUI button 30,"Auto RPM",225,380,185,80,RGB(blue),RGB(white)

'dimension manual speed box
GUI spinbox 24,20,280,350,50,RGB(blue),RGB(white),10,30,max_spindle_rpm
GUI caption 28,"Manual RPM",400,305,LM,RGB(white),RGB(black)  'annotate the spinbox

'dimension button to return to operating page
GUI button 23,"To Operation screen",440,380,350,80,RGB(red),RGB(yellow)

'populate pages with initial values
work_dia=2    'fix for initialisation error div by zero
CtrlVal(dia)=2
CtrlVal(matl)=0     'initialise pointer to aluminium
CtrlVal(P1_target)=str$((matl_speed(CtrlVal(matl))/(pi*work_dia/1000))\1)   'Rpm=matlspeed (m/m) /( pi*D (m))
if val(CtrlVal(P1_target))>max_spindle_rpm then CtrlVal(P1_target)=str$(max_spindle_rpm\1)'truncate and post to P1
CtrlVal(10)= Str$(CtrlVal(dia))   'initialise Page 1 dia display
CtrlVal(overlay)=matl_overlay$(CtrlVal(matl)) 'initialise Page 2 material display
CtrlVal(disp_matl)=CtrlVal(overlay)    'initialise Page 1 material display
CtrlVal(tweak_rpm)=val(CtrlVal(P1_target))   'copy to tweak
CtrlVal(manual)=val(CtrlVal(P1_target))   'copy to P2 manual spinbox
GUI disable 24 :GUI disable 28      'dim the manual selection
CtrlVal(real_rpm)="No Signal"
set_rpm=val(CtrlVal(P1_target))

'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

'MAIN LOOP

Do
Loop      'wait for interrupts

'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&
'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&

'Subroutine to handle gui interrupt
Sub Touched
local auto_start    'used to setup displays for starting in auto mode

Select Case Touch(ref)   'which control is being touched?
'look for belt drive selection
   case range_hi    'telling software which belt position selected
      max_spindle_period=max_spindle_hi_period  'set top period
      min_spindle_period=min_spindle_hi_period  'set bottom period
      max_spindle_rpm=max_spindle_hi_rpm  'set top rpm
      min_spindle_rpm=min_spindle_hi_rpm  'set bottom rpm
      gui bcolour rgb(red),51
      gui bcolour rgb(white),52,53

  case range_med    'telling software which belt position selected
      max_spindle_period=max_spindle_med_period  'set top period
      min_spindle_period=min_spindle_med_period  'set bottom period
      max_spindle_rpm=max_spindle_med_rpm  'set top rpm
      min_spindle_rpm=min_spindle_med_rpm  'set bottom rpm
      gui bcolour rgb(blue),52
      gui bcolour rgb(white),51,53

  case range_lo    'telling software which belt position selected
      max_spindle_period=max_spindle_lo_period  'set top period
      min_spindle_period=min_spindle_lo_period  'set bottom period
      max_spindle_rpm=max_spindle_lo_rpm  'set top rpm
      min_spindle_rpm=min_spindle_lo_rpm  'set bottom rpm
      gui bcolour rgb(green),53
      gui bcolour rgb(white),52,51

'now look for fwd or rev
  Case fwd                 'turn motor on fwd if stopped, otherwise stop it and wait for next button push
    Select Case stopped   'provided it's already stopped
      Case 1         'yes, it's stopped
        If tick2=0 then   'if not=0 then still decelerating. Wait for another button push
          pulse_id=0      'new pulse stream
          Pin(rel_rev)=0     'forward polarity of start winding
          pause 20        'let reverse relay settle before applying power
          PWM 1, 4000, min_spindle_rpm/max_spindle_rpm*100 'set desired speed
          Pin(rel_start) =1   'engage start winding
          Pin(rel_main) =1   'engage main winding
          Pin(cont_run) =1   'start controller
          set_rpm=val(CtrlVal(P1_target))
          tick1=10           'tell timing subroutine to turn start off
          fwd_status=1          'remember running forward
          rev_status=0
          stopped=0   'set flag to show that we are running
          rpm_sync=1    'enable new rpm error convergence 
        end if
      Case 0        'still running
        Select Case rev_status   'check if running in reverse
          Case 1    'yes, running in reverse
              Pin(rel_start) =0   'isolate start winding
              Pin(rel_main) =0   'isolate main winding
              pause 20            'let main winding relay interrupt the current
              Pin(rel_rev)=0   'forward polarity of start winding after current broken
              Pin(cont_run) =0   'stop controller
              CtrlVal(fwd)=0       'ensure fwd control is off
              CtrlVal(rpm_off)=1    'ensure off LED on
              stopped=1   'flag that we are stopped
              fwd_status=0    'remember we have stopped
              rev_status=0
              tick2=40        'start deceleration timer
              CtrlVal(real_rpm)="No signal"   'display in Actual RPM
              rpm_sync=0      'allow new rpm correction
              PWM 1, 4000,0   'turn PWM off
        End Select
  End Select

  Case rev               'turn motor on if stopped. Stop if running fwd and wait for next button push
    Select Case stopped   'provided it's already stopped
      Case 1         'yes, it's stopped
        If tick2=0 then   'if not=0 then still decelerating. Wait for another button push
          pulse_id=0      'new pulse stream
          Pin(rel_rev)=1     'reverse polarity of start winding
          pause 20        'let reverse relay settle before applying power
          PWM 1, 4000, min_spindle_rpm/max_spindle_rpm*100 'set desired speed
          Pin(rel_start) =1   'engage start winding
          Pin(rel_main) =1   'engage main winding          
          Pin(cont_run) =1   'start controller
          set_rpm=val(CtrlVal(P1_target))
          tick1=10   'tell subroutine to turn start off
          stopped=0   'set flag to show that we are running
          rev_status=1    'remember we are running in reverse
          fwd_status=0
          CtrlVal(rpm_off)=0    'ensure off LED off
          rpm_sync=1    'enable new rpm error convergence
        end if 
      Case 0        'still running
        Select Case fwd_status   'check if running fwd
          Case 1    'yes, forward
            Pin(rel_start) =0   'isolate start winding
            Pin(rel_main) =0   'isolate main winding
            pause 20            'let main winding relay interrupt the current
            Pin(rel_rev)=0   'forward polarity of start winding
             Pin(cont_run) =0   'stop controller
          CtrlVal(rev)=0       'ensure rev control is off
            CtrlVal(rpm_off)=1    'ensure off LED on
            fwd_status=0    'remember we have stopped
            rev_status=0
            stopped=1   'flag that we are stopped
            tick2=40        'start deceleration timer
            CtrlVal(real_rpm)="No signal"   'display in Actual RPM
            rpm_sync=0      'allow new rpm correction
            PWM 1, 4000,0   'turn PWM off
        End Select
    End Select

'second, look for tweak, goto settings or stop
  Case go_P2              '"Press for setup" button
    Pin(rel_start) =0   'isolate start winding
    Pin(rel_main) =0   'isolate main winding
    pause 20            'let main winding relay interrupt the current
    Pin(rel_rev)=0   'forward polarity of start winding
    Pin(cont_run) =0   'stop controller
    stopped=1   'flag that we are stopped
    CtrlVal(fwd)=0
    CtrlVal(rev)=0
    CtrlVal(rpm_off)=1
    fwd_status=0    'remember we have stopped
    rev_status=0
    rpm_sync=0      'allow new rpm correction
    tick2=40        'start deceleration timer
    PWM 1, 4000,0   'turn PWM off
    Page 2                'so go to page 2

  Case tweak_rpm
      if CtrlVal(tweak_rpm)<=min_spindle_rpm then CtrlVal(tweak_rpm)=min_spindle_rpm  'minimum spindle speed for this belt position
      if CtrlVal(tweak_rpm)>=max_spindle_rpm then CtrlVal(tweak_rpm)=max_spindle_rpm  'maximum spindle speed for this belt position
      CtrlVal(manual)=CtrlVal(tweak_rpm)    'put the tweak into "manual" P2
      GUI enable manual         'show the manual spinbox
      GUI enable manual_caption 'show the manual caption
      CtrlVal(P1_target)=Str$(CtrlVal(manual))    'copy page 2 manual speed value to page 1 string
      man_auto=1                 'manual mode
      set_rpm=val(CtrlVal(P1_target))
      rpm_sync=1

  Case rpm_off    'unconditionally shut motor down
    Pin(rel_start) =0   'isolate start winding
    Pin(rel_main) =0   'isolate main winding
    pause 20            'let main winding relay interrupt the current
    Pin(rel_rev)=0    'default polarity forward
    Pin(cont_run) =0   'stop controller
    stopped=1   'flag that we are stopped
    fwd_status=0    'remember we have stopped
    rev_status=0
    tick2=40        'start deceleration timer
    CtrlVal(real_rpm)="No signal"   'display in Actual RPM
    rpm_sync=0      'allow new rpm correction
    PWM 1, 4000,0   'turn PWM off

  Case go_P1              '"Press to operate" button
    CtrlVal(real_rpm)="No signal"   'display in Actual RPM
    Page 1                'and go to Page 1

  Case choose_auto         'if the auto RPM button pressed
    GUI disable manual    'dim the manual spinbox
    GUI disable manual_caption  'dim its caption
    man_auto=0
    set_rpm=matl_speed(CtrlVal(20))/(pi*work_dia)   'Rpm=matlspeed (m/m) /( pi*D (m))
    if set_rpm<=min_spindle_rpm then set_rpm=min_spindle_rpm  'minimum spindle speed
    adj_target_period=max_spindle_rpm/set_rpm*max_spindle_period      'initialise error correction
    CtrlVal(tweak_rpm)=set_rpm  'initialise tweak
    CtrlVal(P1_target)=str$(set_rpm\1)  'initialise target

  Case choose_man         'selected manual RPM
    GUI enable manual         'show the manual spinbox
    GUI enable manual_caption 'show the manual caption
    if CtrlVal(manual)<=min_spindle_rpm then CtrlVal(manual)=min_spindle_rpm    'minimum spindle speed
    CtrlVal(P1_target)=Str$(CtrlVal(manual\1))   'copy page 2 manual speed value to page 1 string
    man_auto=1
    set_rpm=val(CtrlVal(P1_target))
    adj_target_period=max_spindle_rpm/set_rpm*max_spindle_period

  Case manual
    CtrlVal(manual)=(CtrlVal(manual)/10)\1*10   'so manual always multiple of 10
    if CtrlVal(manual)<=min_spindle_rpm then CtrlVal(manual)=min_spindle_rpm    'minimum spindle speed
    CtrlVal(P1_target)=Str$(CtrlVal(manual))   'copy page 2 manual speed value to page 1 string
    CtrlVal(tweak_rpm)=CtrlVal(manual\1)      'copy manual to tweak
    man_auto=1
    set_rpm=val(CtrlVal(P1_target))
    adj_target_period=max_spindle_rpm/set_rpm*max_spindle_period

  Case dia
    work_dia= CtrlVal(dia) 'capture workpiece diameter for speed calc
    CtrlVal(10)= Str$(CtrlVal(dia))   'update Page 1 diameter display
    set_rpm=matl_speed(CtrlVal(20))/(pi*work_dia)   'Rpm=matlspeed (m/m) /( pi*D (m))
    if set_rpm<=min_spindle_rpm then set_rpm=min_spindle_rpm  'minimum spindle speed
    adj_target_period=max_spindle_rpm/set_rpm*max_spindle_period

  Case matl
    Select Case CtrlVal(matl)
      Case <8
        CtrlVal(overlay)=matl_overlay$(CtrlVal(20)) 'value of spinbox points to array to get material display
        CtrlVal(11)=CtrlVal(overlay)    'copy the current material to Page 1 material
        set_rpm=matl_speed(CtrlVal(20))/(pi*work_dia)   'Rpm=matlspeed (m/m) /( pi*D (m))
        if set_rpm<=min_spindle_rpm then set_rpm=min_spindle_rpm  'minimum spindle speed
        adj_target_period=max_spindle_rpm/set_rpm*max_spindle_period    'for error adjustment initiation
        CtrlVal(P1_target)=str$(set_rpm\1)    'display target
        CtrlVal(tweak_rpm)=set_rpm\1        'align tweak with target
    End Select
  End Select
  if man_auto=0 then    'in auto mode
    set_rpm=matl_speed(CtrlVal(20))/(pi*work_dia/1000)   'Rpm=matlspeed (m/m) /( pi*D (m))
    if set_rpm>max_spindle_rpm then set_rpm=max_spindle_rpm
    if set_rpm<=min_spindle_rpm then set_rpm=min_spindle_rpm  'minimum spindle speed
    auto_start=set_rpm\1
    CtrlVal(P1_target)=str$(auto_start\1)    'display target
    CtrlVal(tweak_rpm)=auto_start\1        'align tweak with target  
  else if man_auto=1  then    'manual mode
  CtrlVal(P1_target)=str$(CtrlVal(manual\1))    'display target
  CtrlVal(tweak_rpm)=CtrlVal(manual\1)        'align tweak with target  
  end if
end sub

'***********************************************
Sub start_off    'isolate start winding after 750 - 1500 ms
  if tick1=0 then 
    Pin(rel_start) =0   'disengage start whether or not it's engaged
  else 
    tick1=tick1-1              'wait for countdown before disengaging start
  end if
End Sub
'***********************************************
sub decelerate      'count down while machine decelerates
  if tick2<=0 then 
    exit sub
  else
    tick2=tick2-1   'count down
    CtrlVal(fwd)=0    ''prevent fwd or reverse until deceleration times out
    CtrlVal(rev)=0
    CtrlVal(rpm_off)=1
  end if
end sub
'***********************************************
sub get_period      'acquire the controller output frequency
  select case pulse_id   'flag indicating cycle being timed
    case 0          'this is the initial interrupt
      timer=0       'start timer
      pulse_id=1   'set flag to show next pulse requires measurement action
      CtrlVal(real_rpm)=str$(measured_rpm\1)
      exit sub

    case 1          'this cycle needs measurement
pin(35)=1 'debug - view interrupt duration on scope
      period=timer  'catch period in ms  
      timer=0       'restart timer
      pulse_id=1    'set flag to show next pulse requires measurement action
      errornbr=0  'clear for new error measurement
      measured_rpm=max_spindle_rpm*max_spindle_period/period         'actual rpm
      avg_rpm=avg_rpm+measured_rpm
      avg_count=avg_count+1
      if rpm_sync=1 then    'get new setpoint
        target_period=(max_spindle_rpm/set_rpm)*max_spindle_period 'to adjust loop setpoint without affecting target display
        rpm_sync=0      'revert to converging on setpoint
      end if
      errornbr=target_period-period       'error +ve if measured period<target period.
      if tick3=1 then 
        tick3=0
        avg_rpm=avg_rpm/avg_count
        adj_target_period=adj_target_period+feedback_quantity*errornbr    'close error at selected rate
        if adj_target_period<max_spindle_period then adj_target_period=max_spindle_period  'avoid -ve pwm ratio
        if period>1.3*min_spindle_lo_period  then          'too slow
          CtrlVal(real_rpm)="No signal"                'load actual rpm display
        else if tick4=1 then
          CtrlVal(real_rpm)=str$(avg_rpm\1)      'load actual rpm display
          tick4=0
        end if
        avg_rpm=0
        avg_count=0
       pwm_ratio=max_spindle_period/adj_target_period
print "ratiopre=";(pwm_ratio*100)\1/100;
      if pwm_ratio>=1 then pwm_ratio=1 'Val(CtrlVal(P1_target))/max_spindle_rpm 'nominal target
print " ratiopost=";(pwm_ratio*100)\1/100;" targ=";(target_period*100)\1/100;" adj=";(adj_target_period*100)\1/100
      PWM 1, 4000,pwm_ratio*100   ' adjust PWM as required
      period=0
      end if
  end select
pin(35)=0    'debug - view interrupt duration on scope
end sub

'*************************************************
sub feedback    'open gate for rpm interrupt 
  tick3=1
end sub
'***********************************************
sub display_rpm
  tick4=1
end sub
'**************************************************
End  
'***************************************************

'CONTROLS LIST
'1=fwd 'forward drive button numeric
'2=rpm_off  'power off button numeric
'3=rev 'reverse drive button numeric
'4
'5=frame "LATHE-E-BOY"   'draw the frame
'6
'7=go_P2 'button to switch to setup page numeric
'8=displaybox   'target speed disp box string
'9
'10=displaybox    'workpiece diameter string
'11=displaybox    'material string
'12=caption "Target RPM" 'target speed annotation string
'13=caption "Actual RPM" 'actual speed annotation string
'14=caption "diameter(mm)" 'workpiece diameter annotation string
'15=caption "material" 'workpiece material annotation string
'16=caption "Cutting" 'workpiece diameter annotation string
'17=caption "Workpiece" 'workpiece material annotation string
'18
'19=displaybox     'actual speed string
'20=matl 'material spinbox numeric
'21=dia  'diameter spinbox numeric
'22=choose_man=22 'button to choose manual speed selection numeric
'23=go_P1   'button to switch to operation page numeric
'24=manual  'spinbox to manually select RPM numeric
'25=caption "Select material"  'annotate the spinbox  string
'26=
'27=caption "Select diameter mm"  'annotate the spinbox string
'28=manual_caption        'caption alonside manual RPM spinbox string
'29= frame "Setup parameters"    'frame around setup page 2
'30=choose_auto 'button to choose auto speed selection numeric
'31=overlay  'displaybox for material above spinbox P2 string
'32
'33
'34=tweak_rpm   'spinbox to adjust rpm on the fly on P1 numeric
'35
'36
'37=tweak RPM caption  string
'38=tweak RPM spinbox numeric
'39=
'40=
'51=Belt range fast
'52=Belt range medium
'53=Belt range slow


'WIKIPEDIA SPEEDS AND FEEDS
'For appropriate cutting speeds for various materials see
'https://en.wikipedia.org/wiki/Speeds_and_feeds
'The default speeds used are in general the maximum recommended cutting speeds without coolant.


